(
    -- MultiTile Texture: FULL IMPLEMENTATION
	-- 
	-- GetUUID() is the same as the one in CompositeTexturemap.ms, 
	-- means it reuses same graph definition of CompositeMap.
	-- In GetMaps(), replace the semantics with MultiTile methods,
	-- and set proper init values in GetParams()
	
	struct AMGData 
    (
        fn GetUUID mtl context =
        (
            "5d210056-f52c-4c17-8cba-0fef8f265f26"
        ),

        fn GetMaps mtl context =
        (
            local res = #()	
            
            local layer = mtl.tileCount() - (context / 256)
            local newContext = mod context 256

            local subLayer = mtl.getTileTexmap layer 

            if (subLayer != undefined) do
            (
				if (newContext == 1) then
				(
					-- Bump mode
					append res #("fg",           subLayer,  "normalPerturb", newContext) 
				)
				else
				(
					-- Regular mode, also attach alpha
					append res #("fg",           subLayer,  "result", newContext) 
					append res #("alpha",        subLayer,  "alpha",  newContext) 
				)
            )

            -- Recurseively append yourself
            if (layer > 1) do
            (
                append res #("bg",           mtl, "result", context + 256) 
				append res #("bgalpha",      mtl, "alpha", context + 256) 
            )

            res
        ),

        fn GetParams mtl context = 
        (
            local res = #()	

            append res #( "weight",   1.0)  
            append res #( "mode",	  0)  
            append res #( "mask",	  1.0)            -- Default
			append res #( "alpha",	  0.0)            -- Default
            append res #( "bg",	      (color 0 0 0))  -- Default
            append res #( "fg",	      (color 0 0 0))  -- Default

            res
        )
    )

    AMGData()
)